/**
 * Java-Version des bekannten "xeyes-Programms", 
 * das berall fr UNIX-Betriebssysteme in C verfgbar
 * ist.
 * @author: M. Esponda
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;


public class JAugen extends JFrame implements MouseMotionListener {

	// Konstanten
	private static final int EYES_PANEL_WIDTH  = 400;
    private static final int EYES_PANEL_HEIGHT = 400;

 // Instanzvariablen
 // Hintergrund- und Vordergrundfarben
    private Color   bgColor = Color.WHITE;
    private Color   fgColor = Color.BLACK;

 // Hier wird die aktuelle Position der Maus gespeichert
    private Point mousePosition;
    
 // Behlter fr die Augen
    private AugenPanel eyesPanel;
    
 // Um die Animation starten oder stopen
    private boolean    animation_ON_OFF;

    public JAugen() {
    	
        this.animation_ON_OFF = true;
        this.setLayout(null);
        
        this.eyesPanel   = new AugenPanel();
        this.add(eyesPanel);
        
        this.addMouseMotionListener(this);
        this.eyesPanel.addMouseMotionListener(this);

        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        this.mousePosition = new Point(0,0);
        
        this.setSize(EYES_PANEL_WIDTH,EYES_PANEL_HEIGHT+20);
        this.setLocation(100,100);       
        this.setVisible( true );
        
    }// end of constructor

    private void setMousePos(int x, int y) {
        this.mousePosition.setLocation(x, y);
    }

    private Point getMousePos() {
        return this.mousePosition.getLocation();
    }

    private void paintEyes(Graphics g) {

      Dimension d = this.eyesPanel.getSize();
      int scale = 16;
      int eye_size = 50;
      int iris_size = 12;
      int w = d.width;
      int h = d.height;

      Point p = this.getMousePos();
      
      g.setColor(bgColor);
      g.fillRect( 0,0,w,h);
  
   // Setzt die aktuelle Farbe mit der Vordergrundfarbe
      g.setColor( fgColor );
      
    // Zeichnet die Augen   
      g.drawOval( 35+w/2,20, eye_size, eye_size );
      g.drawOval( 105+w/2,20, eye_size, eye_size );

    // Zeichnet die Augenbrauen
      g.drawArc( 35+w/2,5,70,70,80,50 );
      g.drawArc( 87+w/2,5,70,70,50,50 );

    // Anfangsposition der Pupillen
      int eye1_x = 55+w/2;
      int eye1_y = 40;
      int eye2_x = 125+w/2;
      int eye2_y = 40;
      
      int dist, x1=0, y1=0, x2=0, y2=0;
      
      dist = (int) Math.sqrt( (p.x-eye1_x)*(p.x-eye1_x) + (p.y-eye1_y)*(p.y-eye1_y));
      
      if ( dist != 0 ) {
          x1 = (int) ((p.x-eye1_x) * scale / dist);
          y1 = (int) ((p.y-eye1_y) * scale / dist);
          dist = (int) Math.sqrt( (p.x-eye2_x)*(p.x-eye2_x) + (p.y-eye2_y)*(p.y-eye2_y));
          if (dist !=0) {
              x2 = (int) ((p.x-eye2_x) * scale / dist);
              y2 = (int) ((p.y-eye2_y) * scale / dist);
          }
      } else {
          x1 = x2 = y1 = y2 = 0;
      } 
   
   // Jetzt knnen die neuen Pupillen gezeichnet werden
      g.setColor(Color.BLUE);
      g.fillOval( eye1_x+x1, eye1_y+y1, iris_size, iris_size);
      g.fillOval( eye2_x+x2, eye2_y+y2, iris_size, iris_size);
    }
    
     class ButtonPanel extends JPanel implements ActionListener {
    	 
    	 private JButton  startStopButton;
    	 
    	 public ButtonPanel(){	
    		 startStopButton  = new JButton( "Start/Stop" );
             startStopButton.addActionListener(this);
             this.setLocation(300,0);
             this.setSize(100,50); 
             this.add( startStopButton );
    	 }

		public void actionPerformed(ActionEvent e) {
			animation_ON_OFF = !animation_ON_OFF;
		}    
     }// end of class ButtonPanel
     
     class AugenPanel extends JPanel{ 		  	
    	 public AugenPanel(){ 
    		 this.setLayout(new BorderLayout());
    	     this.setLocation(0,0);
    	     this.setSize(EYES_PANEL_WIDTH,EYES_PANEL_HEIGHT);
    		 this.setBackground(Color.YELLOW);
    	     this.add(new ButtonPanel(), BorderLayout.SOUTH);
    	 } 
    	 public void paintComponent(Graphics g){
    		 Dimension dim = this.getParent().getSize();
    		 this.setSize(dim);
    		 paintEyes(g);
    	 }  	 
     }//end of class AugenPanel

	public void mouseDragged(MouseEvent e) {}

	public void mouseMoved(MouseEvent e) {
        setMousePos(e.getX(),e.getY());
        if( animation_ON_OFF ) {
               eyesPanel.repaint();
        }
	}     
	
	public static void main( String[] argv ) {
         new JAugen();
    }

} // end of class JAugen
