/**
 * @author M. Esponda
 * @version 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ClockFrame extends JFrame {

  private static final long serialVersionUID = 1L;

  // Hier wird die aktuelle Zeit des Uhrs gespeichert
  Time time;

  // Hier wird die Time-Objekt gezeigt
  private JLabel timeLabel;

  // Hier kann im Clock-Fenster text ausgeben werden.
  public static JTextArea text;

  private JButton setTimeButton;
  private JTextArea hoursText;
  private JTextArea minsText;
  private JTextArea secsText;

  private JButton stopTime;
  private JButton forward;
  private JButton rewind;
  private int step;

  private Panel buttonsPanel;

  // Konstruktor
  public ClockFrame( Time time ) {
     this.time = time;
     this.setLayout( new GridLayout(3,1,8,8));
     this.setBackground( new Color( 0,180,250 ));
     this.setLocation(200,200);
     this.setSize(500,200);
     
     this.initTextComponent();
     this.initTimePanel();
     this.initButtonsPanel();
     
     this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
     this.setVisible(true);
  }
  
  void initTextComponent(){
	  
	 text = new JTextArea("good afternoon!");
	 JScrollPane textPane = new JScrollPane(text);
     text.setLineWrap(true);
     text.setWrapStyleWord(true);
     this.add(textPane);
  }

  void initTimePanel() {
     timeLabel = new JLabel( "12:00:00" );
     timeLabel.setFont( new Font( "verdana", 4, 36 ) );
     timeLabel.setForeground(Color.white);
     Panel timePanel = new Panel();
     timePanel.setBackground( new Color( 50,100,220 ) );
     timePanel.add(timeLabel);
     this.add(timePanel);
  }

  void initButtonsPanel() {

     setTimeButton = new JButton("set");
     hoursText = new JTextArea("",1,2);
     minsText = new JTextArea("",1,2);
     secsText = new JTextArea("",1,2);

     stopTime = new JButton(" stop ");
     forward = new JButton(" forward ");
     rewind = new JButton(" rewind ");
     buttonsPanel = new Panel();

     buttonsPanel.setLayout( new FlowLayout() );

     stopTime.addActionListener(new StopButtonActionListener());
     forward.addActionListener(new ForwardButtonActionListener());
     rewind.addActionListener(new RewindButtonActionListener());
     setTimeButton.addActionListener(new SetButtonActionListener());

     buttonsPanel.add( setTimeButton );
     buttonsPanel.add( hoursText );
     buttonsPanel.add( minsText );
     buttonsPanel.add( secsText );
     buttonsPanel.add( stopTime );
     buttonsPanel.add( forward );
     buttonsPanel.add( rewind );

     buttonsPanel.setBackground(new Color( 00,180,250 ));
     this.add(buttonsPanel);
  }

  public int getStep() {
    return step;
  }

  public JLabel getTimeLabel() {
     return timeLabel;
  }

  class StopButtonActionListener implements ActionListener {
     public void actionPerformed( ActionEvent ae ) {
        step = 0;
     }
  } // end of class StopButtonActionListener

  class ForwardButtonActionListener implements ActionListener {
     public void actionPerformed( ActionEvent ae ) {
        step = 1;
     }
  } // end of class ForwardButtonActionListener


  class RewindButtonActionListener implements ActionListener {
     public void actionPerformed( ActionEvent ae ) {
        step = -1;
     }
  } // end of class RewindButtonActionListener

  class SetButtonActionListener implements ActionListener {
      public void actionPerformed( ActionEvent ae ) {
         try {
             time.setTime( Integer.parseInt(hoursText.getText()),
                        Integer.parseInt(minsText.getText()),
                        Integer.parseInt(secsText.getText()) );
         } catch( NumberFormatException nfe ) {
            ClockFrame.write( "Wrong or incomplete time input!" );
         } catch( IllegalTimeException ite ){
        	 ClockFrame.write( ite.getMessage() );
         }
         timeLabel.setText(time.toString());
      }
  }
  
  public static void write( String text ) {
      ClockFrame.text.append(text+"\n");
  }
  
} // end of class ClockFrame