/**
 * @author Margarita Esponda
 * @version 1.0
 */

public class MyTime implements Time {

	  // Instanzvariablen
    private int seconds;
    private int minutes;
    private int hours;

	// Konstruktor
	public MyTime(int hours, int minutes, int seconds) 
	      throws IllegalTimeException
	{
		if ( hours<24   && hours>=0  && 
		     minutes<60 && minutes>=0 && 
		     seconds<60 && seconds>=0 )
		{	
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
		}else{
			throw new IllegalTimeException(hours,minutes,seconds);
		}
    }
	
   // Konstruktor
	public MyTime() {
	     this.hours = 0;
	     this.minutes = 0;
	     this.seconds = 0;
	}
	
	/** Methoden */
	public void nextHour()
	{
		//hier programmieren
	}
	
	public void nextMinute()
	{
		//hier programmieren
	}
	
	public void nextSecond()
	{
		//hier programmieren
	}

    public void previousHour()
    {
    	//hier programmieren
    }

    public void previousMinute()
    {
    	//hier programmieren
    }

    public void previousSecond()
    {
    	//hier programmieren
    }
	
	public void setTime( int hours, int minutes, int seconds )
	     throws IllegalTimeException
	{
		if ( ( seconds > 59) || ( seconds < 0) ||
		     ( minutes > 59) || ( minutes < 0) ||
		     ( hours > 23)   || ( hours < 0) ) {
		    throw 
		       new IllegalTimeException("ERROR: The time parameter is outside of the expected range: ",
				                         hours, minutes, seconds );
		}
	    this.hours = hours;
	    this.minutes = minutes;
	    this.seconds = seconds;
	}

	public int getHours() {
		return hours;
	}

	public int getMinutes() {
		return minutes;
	}

	public int getSeconds() {
		return seconds;
	}

	public boolean equal(Time time) {
		if( this.hours == time.getHours() &&
			this.minutes == time.getMinutes() &&
			this.seconds == time.getHours() 
		  )
		      return true;
		return false;
	}

	public void setSeconds(int seconds) throws IllegalTimeException {
		if (seconds<0 || seconds>23)
			throw new IllegalTimeException("ERROR: the seconds-Parameter =" + seconds + " is outside of the expected range");
		this.seconds = seconds;
	}

	public void setMinutes(int minutes) throws IllegalTimeException {
		if (minutes<0 || minutes>23)
			throw new IllegalTimeException("ERROR: the minutes-Parameter =" + minutes + " is outside of the expected range");
		this.minutes = minutes;
	}

	public void setHours(int hours) throws IllegalTimeException {
		if (hours<0 || hours>23)
			throw new IllegalTimeException("ERROR: the hours-Parameter =" + hours + " is outside of the expected range");
		this.hours = hours;
	}

	public int toSeconds() {
		return hours*3600 + minutes*60 + seconds;
	}
 
	/** Ausgabe auf der Konsole*/
	public void print() {
		System.out.println(this.toString());
	}
	
	public String toString() {
		return twoDigits(hours)+":"+twoDigits(minutes)+":"+twoDigits(seconds);
	}
	
	/** Hilfsmethode */
	private static String twoDigits( int number ) {
	     if ( number<10 )
	           return  "0"+number ;
	     return  ""+number ;
	}

} // end of class MyTime
