
/**
 * @author M. Esponda
 * @version 1.0
 */

public class Timer extends Thread {

   public final static int ONE_SECOND = 1000;
   ClockFrame clockframe;

   public Timer( ClockFrame cf ) {
      clockframe = cf;
   }

   public void run() {
      long m = (System.currentTimeMillis()/1000)%86400;
      Time ct = clockframe.time;
      try {
		ct.setTime((int) m/3600, (int)(m/60)%60, (int)(m)%60 );
	} catch (IllegalTimeException e) {
		e.printStackTrace();
	}
      ct.nextHour();
      ct.nextHour();
      while ( true ) {
         try { Thread.sleep(ONE_SECOND);
         } catch ( InterruptedException ie ) {}
         switch (clockframe.getStep()) {
             case  0: break;
             case -1: ct.previousSecond(); break;
             case  1: ct.nextSecond();
         }
         clockframe.getTimeLabel().setText(ct.toString());
      } 
   } // end of run

} // end of class